(in-package "PENMAN")

;;; edited by IK, Thursday, May 25, 2000 at 18:41

;;; BASIC-SPL-MACROS

;;; Most of the following macros were written by Richard Whitney, ISI.
;;; with minor extensions. Some inquiries (presentation-q,
;;; temporal-definiteness-q, possibility-q) have disappeared
;;; somewhere over the years: i.e.,
;;; they are not found in the grammar, and so have been removed here
;;; also.

(defspl-macro :comparative-post-deictic
          ((similar
         :selection-mode-specified-q specified
         :phoric-representative-selection-q phoric
         :same-as-q different
         :similar-q similar)
           (identical
         :selection-mode-specified-q specified
         :phoric-representative-selection-q phoric
         :same-as-q same
         :singularity-q nonsingular
         :identicality-q identical)
           (same
         :selection-mode-specified-q specified
         :phoric-representative-selection-q phoric
         :same-as-q same
         :singularity-q nonsingular
         :identicality-q notidentical)
           (only
         :selection-mode-specified-q specified
         :phoric-representative-selection-q phoric
         :same-as-q same
         :singularity-q singular)
           (different
         :selection-mode-specified-q specified
         :phoric-representative-selection-q phoric
         :same-as-q different
         :similar-q notsimilar
         :duality-q nondual)
           (other
         :selection-mode-specified-q specified
         :phoric-representative-selection-q phoric
         :same-as-q different
         :similar-q notsimilar
         :duality-q dual)))

(defspl-macro :conjunctive
          ((also
         :conjunctive-relation-q conjunctive
         :conjunctive-relation-id (?rr / rhetorical-relation)
         :process-regulated-q notprocessregulated
         :joint-regard-q joint
         :contrastive-q notcontrastive
         :similarity-q notsimilarity
         :correction-q notcorrection
         :disjunctive-q notdisjunctive)
           (alternatively
         :conjunctive-relation-q conjunctive
         :conjunctive-relation-id (?rr / rhetorical-relation)
         :process-regulated-q notprocessregulated
         :joint-regard-q joint
         :contrastive-q contrastive)
           (before
         :conjunctive-relation-q conjunctive
         :conjunctive-relation-id (?rr / rhetorical-relation)
         :process-regulated-q processregulated
         :necessity-q nonecessity
         :sequence-q notsequence
         :time-relation-q timerelation
         :time-precedence-q precedence
         :time-precede-q notsubsequent
         :time-separation-q immediate)
           (besides
         :conjunctive-relation-q conjunctive
         :conjunctive-relation-id (?rr / rhetorical-relation)
         :process-regulated-q notprocessregulated
         :joint-regard-q joint
         :contrastive-q notcontrastive
         :similarity-q notsimilarity
         :correction-q correction)
           (further  ;;; relative sequence  --> potom
         :conjunctive-relation-q conjunctive
         :conjunctive-relation-id (?rr / rhetorical-relation)
         :process-regulated-q processregulated
         :necessity-q nonecessity
         :sequence-q sequence
         :absolute-position-q notabsolute
         :relative-position-q immediate)
           (generally
         :conjunctive-relation-q conjunctive
         :conjunctive-relation-id (?rr / rhetorical-relation)
         :process-regulated-q notprocessregulated
         :joint-regard-q notjoint
         :presentational-relation-q presentational
         :reexpression-q notreexpression
         :abstraction-q abstraction
         :generalization-direction-q generalization)
           (however
         :conjunctive-relation-q conjunctive
         :conjunctive-relation-id (?rr / rhetorical-relation)
         :process-regulated-q notprocessregulated
         :joint-regard-q notjoint
         :presentational-relation-q notpresentational
         :hypothesis-opposition-q hypothesisopposition)
           (immediately
         :conjunctive-relation-q conjunctive
         :conjunctive-relation-id (?rr / rhetorical-relation)
         :process-regulated-q processregulated
         :necessity-q nonecessity
         :sequence-q notsequence
         :time-relation-q timerelation
         :time-precedence-q precedence
         :time-precede-q subsequent
         :time-separation-q immediate)
           (in-fact
         :conjunctive-relation-q conjunctive
         :conjunctive-relation-id (?rr / rhetorical-relation)
         :process-regulated-q notprocessregulated
         :joint-regard-q notjoint
         :presentational-relation-q presentational
         :reexpression-q reexpression)
           (in-particular
         :conjunctive-relation-q conjunctive
         :conjunctive-relation-id (?rr / rhetorical-relation)
         :process-regulated-q notprocessregulated
         :joint-regard-q notjoint
         :presentational-relation-q presentational
         :reexpression-q notreexpression
         :abstraction-q abstraction
         :generalization-direction-q example)
           (joint-however
         :conjunctive-relation-q conjunctive
         :conjunctive-relation-id (?rr / rhetorical-relation)
         :process-regulated-q notprocessregulated
         :joint-regard-q joint
         :contrastive-q notcontrastive
         :similarity-q notsimilarity
         :correction-q notcorrection
         :disjunctive-q disjunctive)
           (previously
         :conjunctive-relation-q conjunctive
         :conjunctive-relation-id (?rr / rhetorical-relation)
         :process-regulated-q processregulated
         :necessity-q nonecessity
         :sequence-q notsequence
         :time-relation-q timerelation
         :time-precedence-q precedence
         :time-precede-q notsubsequent
         :time-separation-q separate
         :small-separation-q small
         :tense past)
           (now ;;; absolute sequence other position --> nyn
         :conjunctive-relation-q conjunctive
         :conjunctive-relation-id (?rr / rhetorical-relation)
         :process-regulated-q processregulated
         :necessity-q nonecessity
         :sequence-q sequence
         :absolute-position-q absolute
         :extremal-position-q notextremal)
           (similarly
         :conjunctive-relation-q conjunctive
         :conjunctive-relation-id (?rr / rhetorical-relation)
         :process-regulated-q notprocessregulated
         :joint-regard-q joint
         :contrastive-q notcontrastive
         :similarity-q similarity)
           (simultaneously
         :conjunctive-relation-q conjunctive
         :conjunctive-relation-id (?rr / rhetorical-relation)
         :process-regulated-q processregulated
         :necessity-q nonecessity
         :sequence-q notsequence
         :time-relation-q timerelation
         :time-precedence-q noprecedence)
           (spatial-besides
         :conjunctive-relation-q conjunctive
         :conjunctive-relation-id (?rr / rhetorical-relation)
         :process-regulated-q processregulated
         :necessity-q nonecessity
         :sequence-q notsequence
         :presentation notpresentational
         :time-relation-q nottimerelation
         :spatial-relation-q spacerelation)
           (then      ;;;; temporal
         :conjunctive-relation-q conjunctive
         :conjunctive-relation-id (?rr / rhetorical-relation)
         :process-regulated-q processregulated
         :necessity-q nonecessity
         :sequence-q notsequence
         :time-relation-q timerelation
         :time-precedence-q precedence
         :time-precede-q subsequent
         :time-separation-q separate
         :small-separation-q notsmall)
           (therefore
         :conjunctive-relation-q conjunctive
         :conjunctive-relation-id (?rr / rhetorical-relation)
         :process-regulated-q processregulated
         :necessity-q necessity)
           (sequence-last  ;;; --> nakonec
         :conjunctive-relation-q conjunctive
         :conjunctive-relation-id (?rr / rhetorical-relation)
         :process-regulated-q processregulated
         :necessity-q nonecessity
         :sequence-q sequence
         :absolute-position-q absolute
         :extremal-position-q extremal-last)
           (sequence-first  ;; -->nejprve
         :conjunctive-relation-q conjunctive
         :conjunctive-relation-id (?rr / rhetorical-relation)
         :process-regulated-q processregulated
         :necessity-q nonecessity
         :sequence-q sequence
         :absolute-position-q absolute
         :extremal-position-q extremal-first)
           (sequence-other ;;; same as "now", --> nyn
         :conjunctive-relation-q conjunctive
         :conjunctive-relation-id (?rr / rhetorical-relation)
         :process-regulated-q processregulated
         :necessity-q nonecessity
         :sequence-q sequence
         :absolute-position-q absolute
         :extremal-position-q notextremal)
           (sequence-relative  ;;; same as further  --> potom
         :conjunctive-relation-q conjunctive
         :conjunctive-relation-id (?rr / rhetorical-relation)
         :process-regulated-q processregulated
         :necessity-q nonecessity
         :sequence-q sequence
         :absolute-position-q notabsolute
         :relative-position-q immediate)
           ))

(defspl-macro :determiner
          ((a
         :identifiability-q  notidentifiable
         :multiplicity-q     unitary
         :amount-attention-q minimalattention)
           (all
         :current-representative-id ?s1
         :potential-representative-id ?s2
         :set-totality-q (?s1 ?s2) total
         :multiplicity-q multiple
         :singularity-q nonsingular
         :set-totality-individuality-q collection
         :amount-attention-q nonminimalattention)
           (another
         :identifiability-q  notidentifiable
         :multiplicity-q     unitary
         :amount-attention-q minimalattention
         :identicality-comparison-modification-q comparison)
           (any
         :amount-attention-q nonminimalattention)
           (both
         :set-totality-q total
         :set-totality-polarity-q positive
         :duality-q dual)
           (each
         :current-representative-id ?s1
         :potential-representative-id ?s2
         :set-totality-q (?s1 ?s2) total
         :multiplicity-q unitary
         :singularity-q singular
         :set-totality-individuality-q individual
         :amount-attention-q nonminimalattention)
           (every
         :current-representative-id ?s1
         :potential-representative-id ?s2
         :set-totality-q (?s1 ?s2) total
         :multiplicity-q unitary
         :singularity-q singular
         :set-totality-individuality-q collection
         :amount-attention-q nonminimalattention)
           (much
         :current-representative-id ?s1
         :potential-representative-id ?s2
         :set-totality-q (?s1 ?s2) partial
         :multiplicity-q unitary
         :singularity-q nonsingular
         :high-quantity-q high
         :amount-attention-q minimalattention
         :diminished-q diminished)
           (no
         :set-totality-q total
         :set-totality-polarity-q negative
         :full-negative-q full
         :duality-q nondual)
           (one
         :amount-attention-q nonminimalattention
         :current-representative-id ?s1
         :potential-representative-id ?s2
         :presuppose-existence-q presupposed
         :selection-particularity-q particular
         :set-totality-q (?s1 ?s2) partial)
           (one-of
         :amount-attention-q nonminimalattention
         :current-representative-id ?s1
         :potential-representative-id ?s2
         :presuppose-existence-q presupposed
         :selection-particularity-q particular
         :set-totality-q (?s1 ?s2) partial)
           (some
         :current-representative-id ?s1
         :potential-representative-id ?s2
         :set-totality-q (?s1 ?s2) partial
         :singularity-q nonsingular
         :deictic-quantity-q lowquantity
         :amount-attention-q minimalattention)
           (the
         :identifiability-q  identifiable
         :amount-attention-q nonminimalattention)
           (that
         :identifiability-q  identifiable
         :proximity-modification-q proximity
         :proximity-mod-id (hearer / person
                        :distance-q distant))
           (this
         :identifiability-q  identifiable
         :proximity-modification-q proximity
         :proximity-mod-id (speaker / person
                        :distance-q nondistant))
           (zero
         :identifiability-q notidentifiable
         :current-representative-id ?s1
         :potential-representative-id ?s2
         :set-totality-q (?s1 ?s2) partial
         :singularity-q nonsingular
         :deictic-quantity-q noquantity
         :amount-attention-q minimalattention)))

(defspl-macro :indefinite-quantity
          ((much
         :quantification-q quantified
         :quantification-id quant
         :high-quantity-q high
         :diminished-q diminished)
           (many
         :quantification-q quantified
         :quantification-id quant
         :number-relativity-q relative
         :high-quantity-q high
         :diminished-q diminished)
           (lots-of
         :quantification-q quantified
         :quantification-id quant
         :number-relativity-q relative
         :high-quantity-q high
         :diminished-q undiminished
         :lot-q multiplelot)
           (a-lot-of
         :quantification-q quantified
         :quantification-id quant
         :number-relativity-q relative
         :high-quantity-q high
         :diminished-q undiminished
         :lot-q singlelot)
           (few
         :quantification-q quantified
         :quantification-id quant
         :number-relativity-q relative
         :high-quantity-q nonhigh
         :low-quantity-q low)
           (any-number-of
         :quantification-q quantified
         :quantification-id quant
         :number-relativity-q relative
         :high-quantity-q nonhigh
         :low-quantity-q nonlow)
           (little
         :quantification-q quantified
         :quantification-id quant
         :high-quantity-q nonhigh
         :low-quantity-q low)))

(defspl-macro :modality
          ((can
         :modality-q modal
         :modality-id (?m / (nonconditional ability)
                  :modality-conditionality-q modalitynonconditional
                  :volitionality-q nonvolitional
                  :modal-necessity-q nonnecessity
                  :ability-q ability))
           (cant
         :modality can
         :modality-polarity negative)
           (could
         :modality-q modal
         :modality-id (?m / (conditional ability)
                  :modality-conditionality-q modalityconditional
                  :volitionality-q nonvolitional
                  :modal-necessity-q nonnecessity
                  :ability-q ability))
           (couldnt
         :modality could
         :modality-polarity negative)
           (may
         :modality-q modal
         :modality-id (?m / (nonconditional general-possibility)
                  :modality-conditionality-q modalitynonconditional
                  :volitionality-q nonvolitional
                  :modal-necessity-q nonnecessity
                  :ability-q nonability))
           (might
         :modality-q modal
         :modality-id (?m / (conditional general-possibility)
                  :modality-conditionality-q modalityconditional
                  :volitionality-q nonvolitional
                  :modal-necessity-q nonnecessity
                  :ability-q nonability))
           (must
         :modality-q modal
         :modality-id (?m / (nonconditional necessity)
                  :modality-conditionality-q modalitynonconditional
                  :volitionality-q nonvolitional
                  :modal-necessity-q necessity))
           (neednt
         :modality must
         :modality-polarity negative)
           (should
         :modality-q modal
         :modality-id (?m / (conditional necessity)
                  :modality-conditionality-q modalityconditional
                  :volitionality-q nonvolitional
                  :modal-necessity-q necessity))
           (shouldnt
         :modality should
         :modality-polarity negative)
           (will
         :modality-q modal
         :modality-id (?m / (nonconditional volitional)
                  :modality-conditionality-q modalitynonconditional
                  :volitionality-q volitional))
           (wont
         :modality will
         :modality-polarity negative)
           (would
         :modality-q modal
         :modality-id (?m / (conditional volitional)
                  :modality-conditionality-q modalityconditional
                  :volitionality-q volitional))
           (wouldnt
         :modality would
         :modality-polarity negative)))

(defspl-macro :modality-polarity
          ((positive :modality-polarity-q modalitypositive)
           (negative :modality-polarity-q modalitynegative)))

(defspl-macro :ordinal
          ((first
        :ordination-q ordinative
        :ordination-id (?o1 / thing
                  :ordinal-type-q first
                  :ordinative-determination-q notspecified)
        :ordinative-selection-q nonselection)
           (second
        :ordination-q ordinative
        :ordination-id (?o1 / thing
                  :ordinal-type-q second
                  :ordinative-determination-q notspecified)
        :ordinative-selection-q nonselection)
           (third
        :ordination-q ordinative
        :ordination-id (?o1 / thing
                  :ordinal-type-q third
                  :ordinative-determination-q notspecified)
        :ordinative-selection-q nonselection)
           (fourth
        :ordination-q ordinative
        :ordination-id (?o1 / thing
                  :ordinal-type-q fourth
                  :ordinative-determination-q notspecified)
        :ordinative-selection-q nonselection)
           (fifth
        :ordination-q ordinative
        :ordination-id (?o1 / thing
                  :ordinal-type-q fifth
                  :ordinative-determination-q notspecified)
        :ordinative-selection-q nonselection)
           (sixth
        :ordination-q ordinative
        :ordination-id (?o1 / thing
                  :ordinal-type-q sixth
                  :ordinative-determination-q notspecified)
        :ordinative-selection-q nonselection)
           (seventh
        :ordination-q ordinative
        :ordination-id (?o1 / thing
                  :ordinal-type-q seventh
                  :ordinative-determination-q notspecified)
        :ordinative-selection-q nonselection)
           (eighth
        :ordination-q ordinative
        :ordination-id (?o1 / thing
                  :ordinal-type-q eighth
                  :ordinative-determination-q notspecified)
        :ordinative-selection-q nonselection)
           (ninth
        :ordination-q ordinative
        :ordination-id (?o1 / thing
                  :ordinal-type-q ninth
                  :ordinative-determination-q notspecified)
        :ordinative-selection-q nonselection)))

(defspl-macro :number
          ((plural
         :multiplicity-q multiple
         :singularity-q nonsingular)
           (singular
         :multiplicity-q unitary
         :singularity-q singular)
           (mass
         :multiplicity-q unitary
         :singularity-q nonsingular)))

(defspl-macro :name
          ((?
         :favor-q classify
         :identifiability-q identifiable
         :lex ?)))

(defspl-macro :noncomparative-post-deictic
          ((?
         :selection-id ?
         :selection-mode-specified-q specified
         :phoric-representative-selection-q notphoric
         )))

(defspl-macro :polarity
          ((positive
         :polarity-id (?po / Positive))
           (negative
         :polarity-id (?po / Negative))
           (variable
         :polarity-id (?po / Polarity-Variable))
           (? :polarity-id ?)))

;;; Following was missing the actualization nonconstraint...
(defspl-macro :pp-theme
          ((? :actualization-constrainer-q nonactualizationconstrainer
          :paragraph-theme-exist-q exists
          :paragraph-theme-id ?
          :reader-knowledge-path-id (? ?) ?thematic-path
          :reader-knowledge-path-id ?included-path
          :path-inclusion-q (?thematic-path ?included-path) contained
          :path-inclusion-q (?included-path ?thematic-path) notcontained)))

(defspl-macro :pronoun
          ((he
        :empty-number-q empty
        :empty-gender-multiplicity-q empty
        :multiplicity-q unitary
        :singularity-q singular
        :gender-q male
        :identifiability-q identifiable)
           (it
        :empty-number-q empty
        :empty-gender-multiplicity-q empty
        :multiplicity-q unitary
        :singularity-q singular
        :gender-q neutral
        :identifiability-q identifiable)
           (that
        :empty-number-q empty
        :empty-gender-multiplicity-q empty
        :multiplicity-q unitary
        :singularity-q singular
        :proximity-modification-q proximity
        :proximity-mod-id ?prox
        :distance-q distant
        :identifiability-q identifiable)
           (this
        :empty-number-q empty
        :empty-gender-multiplicity-q empty
        :multiplicity-q unitary
        :singularity-q singular
        :proximity-modification-q proximity
        :proximity-mod-id ?prox
        :distance-q nondistant
        :identifiability-q identifiable)
           (she
        :empty-number-q empty
        :empty-gender-multiplicity-q empty
        :multiplicity-q unitary
        :singularity-q singular
        :gender-q female
        :identifiability-q identifiable)
           (they
        :empty-number-q empty
        :empty-gender-multiplicity-q empty
        :multiplicity-q multiple
        :singularity-q nonsingular
        :identifiability-q identifiable)))

(defspl-macro :scaling
          ((more   :scalability-q scalable
               :scaling-q scaled
               :proper-subset-q proper
               :exceed-q exceed)
           (most   :scalability-q scalable
               :scaling-q scaled
               :proper-subset-q nonproper)
           (less   :scalability-q scalable
               :scaling-q scaled
               :item-value-id ?item
               :standard-id ?standard
               :standard-mention-q withhold
               :exceed-q (?item ?standard) nonexceed
               :exceed-q (?standard ?item) exceed)
           (as     :scalability-q scalable
               :scaling-q scaled
               :exceed-q nonexceed)
           (enough :scalability-q scalable
               :scaling-q scaled
               :proper-subset-q proper
               :threshhold-value-q threshholdvalue
               :maximum-q nonmaximum)
           (too    :scalability-q scalable
               :scaling-q scaled
               :proper-subset-q proper
               :threshhold-value-q threshholdvalue
               :maximum-q maximum)))

(defspl-macro :scaling-modification
          ((much :comparison-modification-q modification
             :degree-of-modification-q moderatelyhigh)
           (far  :comparison-modification-q modification
             :degree-of-modification-q high)))

(defspl-macro :speechact
          ((assertion
         :speech-act-id (?sa / Assertion
                     :polarity Positive))
           (denial
         :speech-act-id (?sa / Assertion
                     :polarity Negative))
           (yes-no-question
         :speech-act-id (?sa / Question
                     :polarity variable))
           (imperative
         :speech-act-id (?sa / Command
                     :polarity Positive))
           (yes-answer
         :speech-act-id (?sa / Answer
                     :polarity Positive
                     :polarity-answer-q polarityanswer))
           (no-answer
         :speech-act-id (?sa / Answer
                     :polarity Negative
                     :polarity-answer-q polarityanswer))
           (when-question
         :speech-act-id (?sa / Question
                     :polarity positive)
         :question-item-id id
         :temporal-location-specification-q temporallocation
         :temporal-location-id (id / time-interval
                       :question-variable-q variable
                       :location-relation-specificity-q unspecified))
           (why-question
         :speech-act-id (?sa / Question
                     :polarity positive)
         :question-item-id (id / thing
                       :causation-q cause
                       :property-quality-q notproperty)
         :reason-id (id / thing
                   :question-variable-q variable)
         :causation-and-reason-q reason)
           (how-question
         :speech-act-id (?sa / Question
                    :polarity positive)
         :question-item-id (id / thing
                       :circumstance-q circumstance
                       :attitude-q notattitude
                       :question-variable-q variable
                       :property-quality-q property))

           (? :speech-act-id ?)))

(defspl-macro :standard-as
          ((? :scaling as
          :standard-id ?)))

(defspl-macro :standard-enough
          ((? :scaling enough
          :standard-id ?)))

(defspl-macro :standard-less
          ((? :scalability-q scalable
          :scaling-q scaled
          :item-value-id ?item
          :standard-id ?
          :exceed-q (?item ?) nonexceed
          :exceed-q (? ?item) exceed
          :standard-mention-q mention
          :standard-id ?)))

(defspl-macro :standard-more
          ((? :scaling more
          :standard-id ?)))

(defspl-macro :standard-most
          ((? :scaling most
          :standard-id ?)))

(defspl-macro :standard-too
          ((? :scaling too
          :standard-id ?)))

(defspl-macro :substitution
          ((singular-substitution
         :minimal-attention-q minimal
         :semantic-coverage-q covered
         :number singular)
           (plural-substitution
         :minimal-attention-q minimal
         :semantic-coverage-q covered
         :number plural)
           (ellipsis
         :minimal-attention-q minimal
         :semantic-coverage-q covered
         :number mass)))

(defspl-macro :tense
          ((present
         :speech-act-id (?sa / Speech-act
                     :speaking-time-id (?st / time
                                :time-in-relation-to-speaking-time-id ?et
                                :same-as-q (?st ?et) same
                                :precede-q (?st ?et) notprecedes))
         :event-time (?et / time
                  :precede-q (?et ?st) notprecedes))
           (past
         :speech-act-id (?sa / Speech-act
                     :speaking-time-id (?st / time
                                :time-in-relation-to-speaking-time-id ?et
                                :precede-q (?st ?et) notprecedes))
         :event-time (?et / time
                  :precede-q (?et ?st) precedes))
           (future
         :speech-act-id (?sa / Speech-act
                     :speaking-time-id (?st / time
                                :time-in-relation-to-speaking-time-id ?et
                                :precede-q (?st ?et) precedes))
         :event-time (?et / time
                  :precede-q (?et ?st) notprecedes))
           (present-continuous
         :speech-act-id (?sa / Speech-act
                     :speaking-time-id (?st / time
                                :time-in-relation-to-speaking-time-id ?st
                                :time-in-relation-id (?st ?et ?st) ?et
                                :precede-q (?st ?et) notprecedes))
         :event-time (?et / time
                  :precede-q (?et ?st) notprecedes))
           (past-continuous
         :speech-act-id (?sa / Speech-act
                     :speaking-time-id (?st / time
                                :time-in-relation-to-speaking-time-id
                                (?rt / time
                                 :precede-q (?rt ?st) precedes
                                 :precede-q (?rt ?et) notprecedes)
                                :time-in-relation-id (?st ?et ?rt) ?et
; true, but not needed:                                     :precede-q (?st ?et) notprecedes
                                :precede-q (?st ?rt) notprecedes))
         :event-time (?et / time
; true, but not needed:       :precede-q (?et ?st) notprecedes
                  :precede-q (?et ?rt) notprecedes))
           (future-continuous
         :speech-act-id (?sa / Speech-act
                     :speaking-time-id (?st / time
                                :time-in-relation-to-speaking-time-id
                                (?rt / time
                                 :precede-q (?rt ?st) notprecedes
                                 :precede-q (?rt ?et) notprecedes)
                                :time-in-relation-id (?st ?et ?rt) ?et
; true, but not needed:                                     :precede-q (?st ?et) precedes
                                :precede-q (?st ?rt) precedes))
         :event-time (?et / time
; true, but not needed:       :precede-q (?et ?st) notprecedes
                  :precede-q (?et ?rt) notprecedes))

           ;; ALTERNATE FORMS OF -CONTINUOUS TENSES:
           (past-progressive
         :tense past-continuous)
           (present-progressive
         :tense present-continuous)
           (future-progressive
         :tense future-continuous)

           (present-perfect
         :speech-act-id (?sa / Speech-act
                     :speaking-time-id (?st / time
                                :time-in-relation-to-speaking-time-id ?st
                                :time-in-relation-id (?st ?et ?st) ?et
                                :precede-q (?st ?et) notprecedes))
         :event-time (?et / time
                  :precede-q (?et ?st) precedes))
           (past-perfect
         :speech-act-id (?sa / Speech-act
                     :speaking-time-id (?st / time
                                :time-in-relation-to-speaking-time-id
                                (?rt / time
                                 :precede-q (?rt ?st) precedes
                                 :precede-q (?rt ?et) notprecedes)
                                :time-in-relation-id (?st ?et ?rt) ?et
; true, but not needed:                                     :precede-q (?st ?et) notprecedes
                                :precede-q (?st ?rt) notprecedes))
         :event-time (?et / time
; true, but not needed:       :precede-q (?et ?st) precedes
                  :precede-q (?et ?rt) precedes))
           (future-perfect
         :speech-act-id (?sa / Speech-act
                     :speaking-time-id (?st / time
                                :time-in-relation-to-speaking-time-id
                                (?rt / time
                                 :precede-q (?rt ?st) notprecedes
                                 :precede-q (?rt ?et) notprecedes)
                                :time-in-relation-id (?st ?et ?rt) ?et
; true, but not needed:                                     :precede-q (?st ?et) precedes
                                :precede-q (?st ?rt) precedes))
         :event-time (?et / time
; true, but not needed:       :precede-q (?et ?st) notprecedes
                  :precede-q (?et ?rt) precedes))
           (future-in-present
         :speech-act-id (?sa / Speech-act
                     :speaking-time-id (?st / time
                                :time-in-relation-to-speaking-time-id ?st
                                :time-in-relation-id (?st ?et ?st) ?et
                                :precede-q (?st ?et) precedes))
         :event-time (?et / time
                  :precede-q (?et ?st) notprecedes))
          (present-perfect-continuous
         :speech-act-id (?sa / Speech-act
                     :speaking-time-id (?st / time
                                :time-in-relation-to-speaking-time-id
                                (?rt / time
                                 :precede-q (?rt ?st) notprecedes
                                 :precede-q (?rt ?et) notprecedes
                                 :precede-q (?rt ?r2t) notprecedes)
                                :time-in-relation-id (?st ?et ?rt)
                                (?r2t / time
                                  :precede-q (?r2t ?rt) precedes)
                                :precede-q (?r2t ?rt) precedes
                                :precede-q (?st ?et) notprecedes
                                :precede-q (?st ?rt) notprecedes))
         :event-time (?et / time
                  :precede-q (?et ?st) notprecedes
                  :precede-q (?et ?rt) notprecedes)) ))

(defspl-macro :what-question   ;;; Unfortunately, not possible as a :SPEECHACT macro:
                           ;;; Requires coordination of :question-item-id with
                           ;;; arbitrary roles from the body of the SPL.  See PRIMER-51B & PRIMER-52B.
          ((?
         :speech-act-id (q / Question
                   :polarity positive)
         :question-item-id ?)))

;;; PREPOSITIONAL MACROS (REQUIRING ARGUMENTS)

(defspl-macro :above
          ((?
         :place-qual-q place
         :place-qual-id (above / spatial-locating
                       :operator-id (above / above
                               :area-of-coverage-q total)
                       :operand-id ?)
         :spatial-location-specification-q spatiallocation   ;;; for processes
         :spatial-location-id (above / spatial-locating
                       :operator-id (above / above
                               :area-of-coverage-q total)
                       :operand-id ?))))

(defspl-macro :below
          ((?
         :place-qual-q place
         :place-qual-id (below / spatial-locating
                       :operator-id (below / below
                               :area-of-coverage-q total)
                       :operand-id ?)
         :spatial-location-specification-q spatiallocation   ;;; for processes
         :spatial-location-id (below / spatial-locating
                       :operator-id (below / below
                               :area-of-coverage-q total)
                       :operand-id ?))))

(defspl-macro :on-top-of
          ((?
         :place-qual-q place
         :place-qual-id (on-top-of / spatial-locating
                       :operator-id (on-top-of / above
                               :area-of-coverage-q partial
                               :surface-contact-q contact)
                       :operand-id ?)
         :spatial-location-specification-q spatiallocation   ;;; for processes
         :spatial-location-id (on-top-of / spatial-locating
                       :operator-id (on-top-of / above
                               :area-of-coverage-q partial
                               :surface-contact-q contact)
                       :operand-id ?))))

(defspl-macro :over
          ((?
         :place-qual-q place
         :place-qual-id (over / spatial-locating
                       :operator-id (over / above
                               :area-of-coverage-q partial
                               :surface-contact-q noncontact)
                       :operand-id ?)
         :spatial-location-specification-q spatiallocation   ;;; for processes
         :spatial-location-id (over / spatial-locating
                       :operator-id (over / above
                               :area-of-coverage-q partial
                               :surface-contact-q noncontact)
                       :operand-id ?))))

(defspl-macro :under
          ((?
         :place-qual-q place
         :place-qual-id (under / spatial-locating
                       :operator-id (under / below
                               :area-of-coverage-q partial
                               :surface-contact-q noncontact)
                       :operand-id ?)
         :spatial-location-specification-q spatiallocation   ;;; for processes
         :spatial-location-id (under / spatial-locating
                       :operator-id (under / below
                               :area-of-coverage-q partial
                               :surface-contact-q noncontact)
                       :operand-id ?))))

(defspl-macro :underneath
          ((?
         :place-qual-q place
         :place-qual-id (underneath / spatial-locating
                       :operator-id (underneath / below
                               :area-of-coverage-q partial
                               :surface-contact-q contact)
                       :operand-id ?)
         :spatial-location-specification-q spatiallocation   ;;; for processes
         :spatial-location-id (underneath / spatial-locating
                       :operator-id (underneath / below
                               :area-of-coverage-q partial
                               :surface-contact-q contact)
                       :operand-id ?))))

(defspl-macro :aspect
          ((start
         :phasefocus-q focus
         :phase-id (start / start
                  :lex start)
         :start-q start
         :starting-q starting)
           (commence
         :phasefocus-q focus
         :phase-id (commence / start
                  :lex commence)
         :start-q start
         :starting-q notstarting
         :commencing-q commencing)
           (begin
         :phasefocus-q focus
         :phase-id (begin / start
                  :lex begin)
         :start-q start
         :starting-q notstarting
         :commencing-q notcommencing)
           (keep
         :phasefocus-q focus
         :phase-id (keep / ongoing
                  :lex keep)
         :start-q notstart
         :ongoingaspect-q ongoing
         :ongoing-type-q keep)
           (continue
         :phasefocus-q focus
         :phase-id (continue / ongoing
                  :lex continue)
         :start-q notstart
         :ongoingaspect-q ongoing
         :ongoing-type-q continue)
           (stop
         :phasefocus-q focus
         :phase-id (stop / stop
                  :lex stop)
         :start-q notstart
         :ongoingaspect-q notongoing
         :ending-type-q stop)
           (finish
         :phasefocus-q focus
         :phase-id (finish / stop
                  :lex finish)
         :start-q notstart
         :ongoingaspect-q notongoing
         :ending-type-q finish)
           (appear
         :appearance-q appearance
         :phase-id (appear / appearance
                  :lex appear))
           (seem
         :appearance-q appearance
         :phase-id (seem / appearance
                  :lex seem))))
